/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.FileParse;
import jalview.util.Format;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PfamFile
extends AlignFile {
    public PfamFile() {
    }

    public PfamFile(String inFile, String type) throws IOException {
        super(inFile, type);
    }

    public PfamFile(FileParse source) throws IOException {
        super(source);
    }

    public void initData() {
        super.initData();
    }

    public void parse() throws IOException {
        String line;
        int i = 0;
        Hashtable<String, StringBuffer> seqhash = new Hashtable<String, StringBuffer>();
        Vector<String> headers = new Vector<String>();
        while ((line = this.nextLine()) != null) {
            StringBuffer tempseq;
            if (line.indexOf(" ") == 0 || line.indexOf("#") == 0) continue;
            StringTokenizer str = new StringTokenizer(line, " ");
            String id = "";
            if (!str.hasMoreTokens()) continue;
            id = str.nextToken();
            if (seqhash.containsKey(id)) {
                tempseq = (StringBuffer)seqhash.get(id);
            } else {
                tempseq = new StringBuffer();
                seqhash.put(id, tempseq);
            }
            if (!headers.contains(id)) {
                headers.addElement(id);
            }
            tempseq.append(str.nextToken());
        }
        this.noSeqs = headers.size();
        if (this.noSeqs < 1) {
            throw new IOException("No sequences found (PFAM input)");
        }
        for (i = 0; i < headers.size(); ++i) {
            if (seqhash.get(headers.elementAt(i)) != null) {
                if (this.maxLength < seqhash.get(headers.elementAt(i)).toString().length()) {
                    this.maxLength = seqhash.get(headers.elementAt(i)).toString().length();
                }
                Sequence newSeq = this.parseId(headers.elementAt(i).toString());
                newSeq.setSequence(seqhash.get(headers.elementAt(i).toString()).toString());
                this.seqs.addElement(newSeq);
                continue;
            }
            System.err.println("PFAM File reader: Can't find sequence for " + headers.elementAt(i));
        }
    }

    public String print(SequenceI[] s) {
        StringBuffer out = new StringBuffer("");
        int max = 0;
        int maxid = 0;
        for (int i = 0; i < s.length && s[i] != null; ++i) {
            String tmp = this.printId(s[i]);
            if (s[i].getSequence().length > max) {
                max = s[i].getSequence().length;
            }
            if (tmp.length() <= maxid) continue;
            maxid = tmp.length();
        }
        if (maxid < 15) {
            maxid = 15;
        }
        for (int j = 0; j < s.length && s[j] != null; ++j) {
            out.append(new Format("%-" + maxid + "s").form(this.printId(s[j]) + " "));
            out.append(s[j].getSequenceAsString() + "\n");
        }
        out.append("\n");
        return out.toString();
    }

    public String print() {
        return this.print(this.getSeqsAsArray());
    }
}

