.TH "hmmfetch" 1 "Oct 2003" "HMMER 2.3.2" "HMMER Manual"

.SH NAME
.TP 
hmmfetch - retrieve an HMM from an HMM database

.SH SYNOPSIS
.B hmmfetch
.I [options]
.I database
.I name

.SH DESCRIPTION

.B hmmfetch
is a small utility that retrieves an HMM called
.I name
from a HMMER model database called
.I database.
in a new format, 
and prints that model to standard output.
For example,
.I hmmfetch Pfam rrm
retrieves the RRM (RNA recognition motif) model from
Pfam, if the environment variable HMMERDB is
set to the location of the Pfam database.
The retrieved HMM file is written in HMMER 2 ASCII format.

.PP
The database must have an associated GSI index file.
To index an HMM database, use the program
.B hmmindex.

.SH OPTIONS

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.TP
.B -n
Interpret
.I name
as an HMM number instead of a name. Numbering starts at 0.
For example, to fetch the first HMM from an HMM database
called
.B foo,
you would do 
.B hmmfetch -n 0 foo.


.SH SEE ALSO

Master man page, with full list of and guide to the individual man
pages: see 
.B hmmer(1).
.PP
For complete documentation, see the user guide that came with the
distribution (Userguide.pdf); or see the HMMER web page,
http://hmmer.wustl.edu/.

.SH COPYRIGHT

.nf
Copyright (C) 1992-2003 HHMI/Washington University School of Medicine.
Freely distributed under the GNU General Public License (GPL).
.fi
See the file COPYING in your distribution for details on redistribution
conditions.

.SH AUTHOR 

.nf
Sean Eddy
HHMI/Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
http://www.genetics.wustl.edu/eddy/
.fi


