/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.navigation;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/navigation/gotoTypeDeclaration")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class GotoTypeDeclarationTestGenerated extends AbstractGotoTypeDeclarationTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInGotoTypeDeclaration() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/navigation/gotoTypeDeclaration"), Pattern.compile("^(.+)\\.test$"), TargetBackend.ANY, true);
    }

    @TestMetadata("builtinTypeStdlib.test")
    public void testBuiltinTypeStdlib() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/builtinTypeStdlib.test");
    }

    @TestMetadata("explicitParameterInLambda.test")
    public void testExplicitParameterInLambda() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/explicitParameterInLambda.test");
    }

    @TestMetadata("fromFunctionDeclarationName.test")
    public void testFromFunctionDeclarationName() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/fromFunctionDeclarationName.test");
    }

    @TestMetadata("fromFunctionDeclarationReturn.test")
    public void testFromFunctionDeclarationReturn() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/fromFunctionDeclarationReturn.test");
    }

    @TestMetadata("fromFunctionDeclrationExtension.test")
    public void testFromFunctionDeclrationExtension() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/fromFunctionDeclrationExtension.test");
    }

    @TestMetadata("functionCall.test")
    public void testFunctionCall() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/functionCall.test");
    }

    @TestMetadata("itExtensionLambda.test")
    public void testItExtensionLambda() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/itExtensionLambda.test");
    }

    @TestMetadata("itParameterInLambda.test")
    public void testItParameterInLambda() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/itParameterInLambda.test");
    }

    @TestMetadata("noParametersLambda.test")
    public void testNoParametersLambda() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/noParametersLambda.test");
    }

    @TestMetadata("thisExtensionFunction.test")
    public void testThisExtensionFunction() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/thisExtensionFunction.test");
    }

    @TestMetadata("thisExtensionFunctionWithAnnotationOnReceiver.test")
    public void testThisExtensionFunctionWithAnnotationOnReceiver() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/thisExtensionFunctionWithAnnotationOnReceiver.test");
    }

    @TestMetadata("thisExtensionFunctionWithGenericReceiver.test")
    public void testThisExtensionFunctionWithGenericReceiver() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/thisExtensionFunctionWithGenericReceiver.test");
    }

    @TestMetadata("thisExtensionLambda.test")
    public void testThisExtensionLambda() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/thisExtensionLambda.test");
    }

    @TestMetadata("thisInExtensionPropertyAccessor.test")
    public void testThisInExtensionPropertyAccessor() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/thisInExtensionPropertyAccessor.test");
    }

    @TestMetadata("variableType.test")
    public void testVariableType() throws Exception {
        runTest("idea/testData/navigation/gotoTypeDeclaration/variableType.test");
    }
}
