# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.preview.trusted_comms.branded_channel import BrandedChannelList
from twilio.rest.preview.trusted_comms.brands_information import BrandsInformationList
from twilio.rest.preview.trusted_comms.cps import CpsList
from twilio.rest.preview.trusted_comms.current_call import CurrentCallList


class TrustedComms(Version):

    def __init__(self, domain):
        """
        Initialize the TrustedComms version of Preview

        :returns: TrustedComms version of Preview
        :rtype: twilio.rest.preview.trusted_comms.TrustedComms.TrustedComms
        """
        super(TrustedComms, self).__init__(domain)
        self.version = 'TrustedComms'
        self._branded_channels = None
        self._brands_information = None
        self._cps = None
        self._current_calls = None

    @property
    def branded_channels(self):
        """
        :rtype: twilio.rest.preview.trusted_comms.branded_channel.BrandedChannelList
        """
        if self._branded_channels is None:
            self._branded_channels = BrandedChannelList(self)
        return self._branded_channels

    @property
    def brands_information(self):
        """
        :rtype: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationList
        """
        if self._brands_information is None:
            self._brands_information = BrandsInformationList(self)
        return self._brands_information

    @property
    def cps(self):
        """
        :rtype: twilio.rest.preview.trusted_comms.cps.CpsList
        """
        if self._cps is None:
            self._cps = CpsList(self)
        return self._cps

    @property
    def current_calls(self):
        """
        :rtype: twilio.rest.preview.trusted_comms.current_call.CurrentCallList
        """
        if self._current_calls is None:
            self._current_calls = CurrentCallList(self)
        return self._current_calls

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.TrustedComms>'
