% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_parameters.R
\name{find_parameters}
\alias{find_parameters}
\alias{find_parameters.default}
\title{Find names of model parameters}
\usage{
find_parameters(x, ...)

\method{find_parameters}{default}(x, flatten = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}

\item{flatten}{Logical, if \code{TRUE}, the values are returned
as character vector, not as list. Duplicated values are removed.}

\item{verbose}{Toggle messages and warnings.}
}
\value{
A list of parameter names. For simple models, only one list-element,
\code{conditional}, is returned.
}
\description{
Returns the names of model parameters, like they typically
appear in the \code{summary()} output. For Bayesian models, the parameter
names equal the column names of the posterior samples after coercion
from \code{as.data.frame()}. See the documentation for your object's class:
\itemize{
\item{\link[=find_parameters.BGGM]{Bayesian models} (\pkg{rstanarm}, \pkg{brms}, \pkg{MCMCglmm}, ...)}
\item{\link[=find_parameters.gamlss]{Generalized additive models} (\pkg{mgcv}, \pkg{VGAM}, ...)}
\item{\link[=find_parameters.betamfx]{Marginal effects models} (\pkg{mfx})}
\item{\link[=find_parameters.emmGrid]{Estimated marginal means} (\pkg{emmeans})}
\item{\link[=find_parameters.glmmTMB]{Mixed models} (\pkg{lme4}, \pkg{glmmTMB}, \pkg{GLMMadaptive}, ...)}
\item{\link[=find_parameters.zeroinfl]{Zero-inflated and hurdle models} (\pkg{pscl}, ...)}
\item{\link[=find_parameters.averaging]{Models with special components} (\pkg{betareg}, \pkg{MuMIn}, ...)}
}
}
\section{Model components}{

Possible values for the \code{component} argument depend on the model class.
Following are valid options:
\itemize{
\item \code{"all"}: returns all model components, applies to all models, but will only
have an effect for models with more than just the conditional model component.
\item \code{"conditional"}: only returns the conditional component, i.e. "fixed effects"
terms from the model. Will only have an effect for models with more than
just the conditional model component.
\item \code{"smooth_terms"}: returns smooth terms, only applies to GAMs (or similar
models that may contain smooth terms).
\item \code{"zero_inflated"} (or \code{"zi"}): returns the zero-inflation component.
\item \code{"dispersion"}: returns the dispersion model component. This is common
for models with zero-inflation or that can model the dispersion parameter.
\item \code{"instruments"}: for instrumental-variable or some fixed effects regression,
returns the instruments.
\item \code{"location"}: returns location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} (everything that are
fixed or random effects - depending on the \code{effects} argument - but no
auxiliary parameters).
\item \code{"distributional"} (or \code{"auxiliary"}): components like \code{sigma}, \code{dispersion},
\code{beta} or \code{precision} (and other auxiliary parameters) are returned.
}
}

\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
find_parameters(m)
}
