% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulative.R
\name{cummean}
\alias{cummean}
\alias{cumany}
\alias{cumall}
\title{Cumulative versions of any, all, and mean}
\usage{
cummean(x)

cumany(x)

cumall(x)
}
\arguments{
\item{x}{For \code{cumall()} and \code{cumany()}, a logical vector; for \code{cummean()} an integer or numeric vector.}
}
\value{
A vector the same length as \code{x}.
}
\description{
{poorman} provides \code{cumall()}, \code{cumany()}, and \code{cummean()} to complete R's set of cumulative functions.
}
\section{Cumulative logical functions}{


These are particularly useful in conjunction with \code{filter()}:
\itemize{
\item \code{cumall(x)}: all cases until the first \code{FALSE}.
\item \code{cumall(!x)}: all cases until the first \code{TRUE}.
\item \code{cumany(x)}: all cases after the first \code{TRUE}.
\item \code{cumany(!x)}: all cases after the first \code{FALSE}.
}
}

\examples{
# `cummean()` returns a numeric/integer vector of the same length
# as the input vector.
x <- c(1, 3, 5, 2, 2)
cummean(x)
cumsum(x) / seq_along(x)

# `cumall()` and `cumany()` return logicals
cumall(x < 5)
cumany(x == 3)

# `cumall()` vs. `cumany()`
df <- data.frame(
  date = as.Date("2020-01-01") + 0:6,
  balance = c(100, 50, 25, -25, -50, 30, 120)
)
# all rows after first overdraft
df \%>\% filter(cumany(balance < 0))
# all rows until first overdraft
df \%>\% filter(cumall(!(balance < 0)))

}
